/*
 * json_utils.cpp
 *
 *
 *
 */
#include "alliance_telematics_AppMain.h"
#include "alliance_telematics_DLT_Trace_Header.h"
#include "alliance_telematics_AppMain_Trace.h"
#include "json_utils.h"
#define TRACE_FILE_NAME "json_utils.cpp"

json_utils::json_utils()
{
    ATEL_LOG_INFO(("json_utils()"));
}
json_utils::~json_utils()
{
    ATEL_LOG_INFO(("~json_utils()"));
}
tBool json_utils::getJSONObject(Json::Value& input, tCString jsonObjName, Json::Value& output) {
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if (!value.isObject()) {
        ATEL_LOG_INFO(("%s is not an Object",jsonObjName));
        return FALSE;
    } else if(value == Json::Value::null){ // Cannot find JSONObject for wrong name.
        ATEL_LOG_INFO(("%s cannot be found",jsonObjName));
        return FALSE;
    } else {
        output = value;
        return TRUE;
    }
}

tBool json_utils::getJSONArray(Json::Value& input, tCString jsonObjName, Json::Value& output) {

    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found",jsonObjName));
        return FALSE;
    } else if (!value.isArray()) {
        ATEL_LOG_INFO(("%s is not an Array",jsonObjName));
        return FALSE;
    }
    //	else if (value.isArray() && value.size() == 0) {
    //		ATEL_LOG_INFO(("%s is empty",jsonObjName));
    //		return FALSE;
    //	}
    else if (value.isArray()) {
        output = value;
        return TRUE;
    }

    return FALSE;
}

tBool json_utils::getString(Json::Value& input, tCString jsonObjName, std::string& output) {

    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found",jsonObjName));
        return FALSE;
    } else if (!value.isString()) {
        ATEL_LOG_INFO(("%s is not an String",jsonObjName));
        return FALSE;
    } else {
        std::string temp = value.asCString();
        output = temp;
        ATEL_LOG_INFO(("Get String: %s",temp.c_str()));
        return TRUE;
    }
}

tBool json_utils::gettBool(Json::Value& input, tCString jsonObjName, tBool& output) {
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found",jsonObjName));
        return FALSE;
    } else if (!value.isBool()) {
        ATEL_LOG_INFO(("%s is not a Bool",jsonObjName));
        return FALSE;
    } else {
        output = value.asBool();
        return TRUE;
    }
}

tBool json_utils::gettU8UInt(Json::Value& input, tCString jsonObjName, tU8& output) {
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found",jsonObjName));
        return FALSE;
    } else if (!value.isInt()) {
        ATEL_LOG_INFO(("%s is not an Integer",jsonObjName));
        return FALSE;
    } else {
        output = (tU8) value.asUInt();
        return TRUE;
    }
}

tBool json_utils::gettU16UInt(Json::Value& input, tCString jsonObjName, tU16& output) {
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found",jsonObjName));
        return FALSE;
    } else if (!value.isInt()) {
        ATEL_LOG_INFO(("%s is not an Integer",jsonObjName));
        return FALSE;
    } else {
        output = (tU16) value.asUInt();
        return TRUE;
    }
}

tBool json_utils::gettU32UInt(Json::Value& input, tCString jsonObjName, tU32& output) {
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found",jsonObjName));
        return FALSE;
    } else if (!value.isInt()) {
        ATEL_LOG_INFO(("%s is not an Integer",jsonObjName));
        return FALSE;
    } else {
        output = (tU32) value.asUInt();
        return TRUE;
    }
}

tBool json_utils::gettU64UInt(Json::Value& input, tCString jsonObjName, tU64& output) {
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found",jsonObjName));
        return FALSE;
    } else if (!value.isInt()) {
        ATEL_LOG_INFO(("%s is not an Integer",jsonObjName));
        return FALSE;
    } else {
        output = (tU64) value.asUInt();
        return TRUE;
    }
}

tBool json_utils::getDouble(Json::Value& input, tCString jsonObjName, double& output){
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if (value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found", jsonObjName));
        return FALSE;
    }else if(!value.isDouble()){
        ATEL_LOG_INFO(("Not a double type"));
        return FALSE;
    }
    else {
        output = (double) value.asDouble();
        ATEL_LOG_INFO(("Double: %lf", output));
        return TRUE;
    }
}

tBool json_utils::getFloat(Json::Value& input, tCString jsonObjName, float& output){
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if (value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ATEL_LOG_INFO(("%s cannot be found", jsonObjName));
        return FALSE;
    }else if(!value.isNumeric()){
        ATEL_LOG_INFO(("Not a numeric type"));
        return FALSE;
    }
    else {
        output = (float) value.asFloat();
        ATEL_LOG_INFO(("Double: %f", output));
        return TRUE;
    }
}
